// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Stewart Berry - Caliper Corporation - 2003

    // This resource file demonstrates how to import all the Shapefiles in a directory
    // where all such files have a common coordinate system 
    // (in this case the common coordinate system is the British National Grid)
    
    // The macro illustrates how to:
    // 1. Import all the Shapefiles in a directory
    // 2. Import all the Shapefiles in a directory, specifying their coordinate system
    // 3. Error handling
    // 4. Use of the functions ChooseDirectory() and ImportArcViewShape()

    // To run this macro using the GISDK toolbox:
    // 1. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 2. Compile this macro in test mode using the first button (Compile).
    // 3. Run this macro by clicking the second button (Test), typing the macro 
    //    name "Batch Import BNG Shapefiles", clicking the Macro radio button, & clicking OK.
    // 4. The inpath is a directory containing Shapefile(s) in the BNG
    // 5. The outpath is the directory where you want the new *.DBD file(s) to be saved

Macro "Batch Import BNG Shapefiles"

    // The inpath and the outpath are the only variables the user needs to specify
    // Special error handling if the users chooses cancel
    on Escape do
        return()
    end
    // Use the choose directory dbox to choose the in and out directories
    in_path = ChooseDirectory("Choose the input directory", )
	out_path = in_path
	out_path = ChooseDirectory("Choose the output directory", {{"Initial Directory",out_path}})
    // Cancel special error handling defined above
    on escape default
	
	// Get a listing of the contents of the directory that contains the Shapefiles
    tmp = GetDirectoryInfo(in_path + "\\*.shp", "file")
        
    // Loop for each Shapefile
    for i = 1 to tmp.length do

        // Get the Shapefile name without extension
        lyr_name = tmp[i][1]
        {name,} = parsestring(tmp[i][1],".")
        // Create a new dbd file name using the Shapefile name
        dbd_name = name + ".dbd"

        // Set the variables used in the options array to null
        proj = null
        transform = null
        datum_conv = null
        options = null

        // Define the options array using the British National Grid and the file name
        options = {
                    {"Projection", "world:bng", {"units=m"}},
                    {"Label", name},
                    {"Layer Name", name},
                    {"Median Split", "True"},
                    {"Node Layer Name", "Endpoints"}
                  }
        
        // Import the Shapefile from the inpath and out as a dbd to the outpath using the
        // variables and the options array defined above
        ImportArcViewShape(in_path + "\\" + lyr_name, out_path + "\\" + dbd_name, options)
    
    end

endmacro